function design = ePCA_1d(m, n, d, ePCA)
%ePCA_1d Generates a 1D ePCA array.
% Reference
% [1] W. Zheng, X. Zhang, Y. Wang, J. Shen, and B. Champagne, Padded coprime arrays for improved DOA estimation: Exploiting hole representation and filling strategies, IEEE Trans. Signal Process., vol. 68,pp. 4597C4611, July 2020.
% ========= array configuration ============
L_cadis1 = [0:m:(n-1)*m];
L_cadis21 = [m*n+m+n:n:m*n+m+n+n*(2*m-2-floor(m/2))];
P_31=[m*n-n*(floor(m/2)-1):n:m*n-n];
P_32 = m*n-m-floor(m/2)*n;
P_3 = [P_31 P_32];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
add = [L_cadis1 L_cadis21 P_3];
arr_indices = sort(add);


if d <= 0 || ~isreal(d)
    error('d must be a positive real number.');
end
if nargin <= 3
    name = sprintf('ePCA array %d sensors', n);
elseif ~ischar(name)
    error('Name must be a string.');
end
design.element_indices = arr_indices;
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.dim = 1;
design.type = 'ePCA';
design.name = name;
end